/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class ItemListModule
extends AbstractBuildingModule
implements IItemListModule,
IPersistentModule {
    private static final String TAG_ITEMLIST = "itemList";
    private ImmutableList<ItemStorage> itemsAllowed = ImmutableList.of();
    private final String id;

    public ItemListModule(String id) {
        this.id = id;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        ArrayList<ItemStorage> allowedItems = new ArrayList<ItemStorage>();
        if (compound.func_74764_b(this.id)) {
            ListNBT filterableList = compound.func_74775_l(this.id).func_150295_c(TAG_ITEMLIST, 10);
            for (int i = 0; i < filterableList.size(); ++i) {
                allowedItems.add(new ItemStorage(ItemStack.func_199557_a((CompoundNBT)filterableList.func_150305_b(i))));
            }
        } else {
            ListNBT filterableList = compound.func_150295_c(TAG_ITEMLIST, 10);
            for (int i = 0; i < filterableList.size(); ++i) {
                try {
                    CompoundNBT listItem = filterableList.func_150305_b(i);
                    String id = listItem.func_74779_i("id");
                    if (!this.id.equals(id)) continue;
                    ListNBT filterableItems = listItem.func_150295_c(TAG_ITEMLIST, 10);
                    for (int j = 0; j < filterableItems.size(); ++j) {
                        allowedItems.add(new ItemStorage(ItemStack.func_199557_a((CompoundNBT)filterableItems.func_150305_b(j))));
                    }
                    continue;
                }
                catch (Exception e) {
                    Log.getLogger().info("Removing incompatible stack");
                }
            }
        }
        this.itemsAllowed = ImmutableList.copyOf(allowedItems);
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        CompoundNBT moduleCompound = new CompoundNBT();
        ListNBT filteredItems = new ListNBT();
        for (ItemStorage item : this.itemsAllowed) {
            CompoundNBT itemCompound = new CompoundNBT();
            item.getItemStack().func_77955_b(itemCompound);
            filteredItems.add((Object)itemCompound);
        }
        moduleCompound.func_218657_a(TAG_ITEMLIST, (INBT)filteredItems);
        compound.func_218657_a(this.id, (INBT)moduleCompound);
    }

    @Override
    public void addItem(ItemStorage item) {
        if (!this.itemsAllowed.contains((Object)item)) {
            this.itemsAllowed = ImmutableList.builder().addAll(this.itemsAllowed).add((Object)item).build();
            this.markDirty();
        }
    }

    @Override
    public boolean isItemInList(ItemStorage item) {
        return this.itemsAllowed.contains((Object)item);
    }

    @Override
    public void removeItem(ItemStorage item) {
        ArrayList<ItemStorage> allowedItems = new ArrayList<ItemStorage>((Collection<ItemStorage>)this.itemsAllowed);
        allowedItems.remove(item);
        this.itemsAllowed = ImmutableList.copyOf(allowedItems);
        this.markDirty();
    }

    public ImmutableList<ItemStorage> getList() {
        return this.itemsAllowed;
    }

    @Override
    public String getListIdentifier() {
        return this.id;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.writeInt(this.itemsAllowed.size());
        for (ItemStorage item : this.itemsAllowed) {
            buf.func_150788_a(item.getItemStack());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

